clear all
clc
close all

load AAMTData

n=length(row);
Y=zeros(1,n);
for i=1:n
    Y(i)=modal{i}(1); %choose earlier action when multiple modal, should test for robustness
end

%% Uniform NE

% Randomize prediction over NE
Q=1000;
AccNE=zeros(1,Q);
for q=1:Q
    accne=zeros(1,n);
    for i=1:n
        ne=find(IndNE{i});
        m=length(ne);
        if m>0
            r=randi(m);
            accne(i)=logical(Y(i)==ne(r));
            clear ne
        else
            r=randi(3);
            accne(i)=logical(Y(i)==r);
        end
    end
    AccNE(q)=mean(accne);
end

'Accuracy Uniform-NE'
mean(AccNE)

'Standard Error'
sqrt(var(AccNE))


%% Level 1

% Find Level 1 Prediction
lev1=cell(1,n);
for i=1:n
    sumrow=sum(row{i},2);
    lev1{i}=find(sumrow==max(sumrow));
end

'Level 1 Accuracy'
% Randomize prediction when not unique
Q=1000;
AccLev1=zeros(1,Q);
for q=1:Q
    [resampleY,ind]=datasample(Y,n);
    resamplelev1=lev1(ind);
    acclev1=zeros(1,n);
    for i=1:n
        m=length(lev1{i});
        pred=randi(m);
        acclev1(i)=logical(Y(i)==lev1{i}(pred));
    end
    AccLev1(q)=mean(acclev1);
end

'Accuracy Level-1'
mean(AccLev1)

'Level-1 SE'
sqrt(var(AccLev1))


%% Lexicographic Rule: predict if Pareto-Dominant NE, then Lev1(alpha)

% Find Level 1(alpha) Prediction
alpha=0.41;
lev1R=zeros(1,n);
for i=1:n
    sumrow=sum(row{i}.^alpha,2);
    lev1R(i)=find(sumrow==max(sumrow));
end

ind=[3,15,27]; %Indices for whether a1,a2,a3 are part of Pareto-Dominant NE
FeatParetoNE=FeaturesAct(:,ind);

error=zeros(1,n);
for i=1:n
    paretoNE=find(FeatParetoNE(i,:));
    m=length(paretoNE);
    if m>0
        r=randi(m);
        error(i)=logical(paretoNE(r)~=Y(i));
    else
        error(i)=logical(lev1R(i)~=Y(i));
    end
end

'Accuracy using Lexicographic Rule'
1-mean(error)

